'''
Copyright Dr Paul Brown and Prof. Trevor Fenner 2020.
'''

'''
chars is the character representation of the vertex weight
ords is the weight corresponding to the character
RTList is the cached list of rooted trees
RFList is the cached list of forests, 
i.e., the trees in RTLists with the root removed
RTqstart[n][q] is the index of the first tree in RTList[n] for which its 
first subtree has order q
RTDict{} contains the adjacency lists / matrices of the rooted trees keyed 
by their canonical weight sequences
'''

chars = []
ords = {}

# initialise for weights <= 9
for j in range(9):
    c = chr(48 + j)
    chars.append(c)
    ords[c] = j

# initialise for weights >= 10
for j in range(21):
    c = chr(65 + j)
    chars.append(c)
    ords[c] = j + 9

# maximum value of L
MaxL = 20
# allocate space for RTList, RFList and RTqstart
RTList = [[]] * MaxL
RFList = [[]] * MaxL
RTqstart = [[0 for j in range(i)] for i in range(MaxL)]
# RTDict is the dictionary for looking up adjacency lists / matrices
# using the weight sequences
RTDict = {}

# initialise for rooted trees of small order
RTList[1] = ['1']
RTList[2] = ['21']
RTList[3] = ['321', '311']
RTList[4] = ['4321', '4311', '4211', '4111']

# initialise forests (rooted trees with root removed)
RFList[1] = ['']
RFList[2] = ['1']
RFList[3] = ['21', '11']
RFList[4] = ['321', '311', '211', '111']

RTqstart[3][1] = 1
RTqstart[4][2] = 2
RTqstart[4][1] = 3