function ex2(iname)
% ex2 - example of an integral over the n-sphere
%
% \int_{r<1} cos(sum(x))   
%  see: A. H. Stroud "Some Fifth Degree Integration Formulas for
%  Symmetric Regions", Mathematics of Computation, 20 (1966), pp. 90-97.


if nargin<1
    iname='double.txt'
end

rule=evaluate(iname);

% calculate accurate values of the integral in dimensions 2 through 9
M=17;
int=zeros(1,M);
for n=2:9
    V=2/n*pi^(n/2)/gamma(n/2); % volume of n-sphere, Stroud p 220
    k=4/n*[1:M].^2+2*[1:M];
    sgn=-1;
    for i=M:-1:1
        int(n)=(sgn+int(n))/k(i);
        sgn=-sgn;
    end
    int(n)=(1+int(n))*V;
fprintf('%d %13.10f\n', n, int(n));
end

fprintf('  d   N   o        estimate             true                 error\n');
for d=2:9
    for k=1:length(rule)
        
        x=rule(k).x;
        if d==rule(k).d;
            if strcmp(rule(k).problem,'S')
                est=integrate(@(x) cos(sum(x)),rule(k).x);
                true=int(d);
                x=rule(k).x;
                N=sum(x(:,d+1)~=0);
                fprintf('%3d %3d %3d %19.16f  %19.16f  %19.16f\n', ...
                        d, N, rule(k).o, est, true, est-true);
            end
        end
    end
end

function est = integrate(fun, x)

[N,d]=size(x);
d=d-1;
v=zeros(1,N);
for i=1:N
    v(i)=fun(x(i,1:d));
end
w=x(:,d+1);
est=v*w;

