function c5_22_4
% c5_22_4 - construct 22 point integration rules with dimension 5
% and degree 4, and write them to c5_22_4.txt

%           r1         r2          W0           W1           W2
rule(  sqrt(5),   sqrt(8),        1/4,        1/18,        1/36,  'G');
rule(sqrt(5/2),         2, pi^(5/2)/4, pi^(5/2)/18, pi^(5/2)/36, 'E2');
rule(sqrt(5)/3, sqrt(8)/3, 2*pi^2/105,  4*pi^2/105,  2*pi^2/105,  'S');
rule( sqrt(40),         8,    pi^2*28,    8*pi^2/3,    4*pi^2/3, 'E1');

function x = rule(r1,r2,w0,w1,w2,problem)
% rule - construct a 22 point integration rule with dimension 5 and degree 4

if nargin<6
    problem='G';
end

n=5;
m=4;
x0=zeros(1,5);

a=(-1-(n-1)*sqrt(n+1))/n;
b=(-1+sqrt(n+1))/n;
% these nodes are at vertices of a regular 5-simplex
s=[1 1 1 1 1
   a b b b b
   b a b b b
   b b a b b
   b b b a b
   b b b b a];

x1=s*r1/sqrt(5);
k=0;
for i=2:n+1
    for j=1:i-1
        k=k+1;
        % these nodes are at the midpoint of
        % each edge of a 5-simplex
        x2(k,:)=-(s(i,:)+s(j,:))*r2/sqrt(8);
    end
end

x=[x0 w0
   x1 ones(6,1)*w1
   x2 ones(15,1)*w2];

plain(x,4,['integral ' problem],'c5_22_4.txt');

% err=verify(x,4,problem);
% fprintf('%d_%d_%d, %s: maximum error %15.12g\n',n, size(x,1), m, problem, err);
