/* MPoint.java
 * The Point object represents points to be plotted in
 * a 2-D plot. The points have various attributes that can
 * be set to alter how they look. The attributes include color,
 * style and size. In particular, see below for the meaning of
 * the size attribute.
 */

import java.awt.*;
import java.io.*;

class MPoint implements Serializable {

    public double x,y;       // coordinates
    public Color color;      // Color
    public int style;        
    public static final int STYLE_LINTERP   = 6;
    public static final int STYLE_TEXT      = 5;
    public static final int STYLE_X         = 4;
    public static final int STYLE_DISC      = 3;
    public static final int STYLE_RECT      = 2;
    public static final int STYLE_CROSS     = 1;
    public static final int STYLE_CIRCLE    = 0;

    static final int defaultSize = 3;

    /* The style value selects the symbol used to display the point 
     * on the plot as enumerated below:
     * 0:   point appears as a circle
     * 1:   point appears as a cross
     * 2:   point appears as a rectangle
     * 3:   point appears as a disc
     * 4:   point appears as an "X"
     * 5:   point contains a text string
     * 6:   plot a linear interpolant between successive points
     */
    public int size;         // size of the displayed point symbol
    public String text;

    public MPoint() {
	/* Initialize this point with default values */
	x=0;
	y=0;
	color=Color.black;
	style=3;
	size=defaultSize;
	text="";
    }

    public MPoint(double s, double t) {
	x=s;
	y=t;
	color=Color.black;
	style=3;
	size=defaultSize;
	text="";
    }

    public MPoint(double s, double t, String u) {
	x=s;
	y=t;
	color=Color.black;
	style=5;
	size=defaultSize;
	text=u;
    }

    void setSize(int j) {
	size=j;
    }

    void setColor(Color c) {
	color=c;
    }

    Color getColor() {
	return color;
    }

    void brighter() {
	color=color.brighter();
    }

    void setText(String s) {
	text=s;
	style=5;
    }

    String getText() {
	return text;
    }

    void setStyle(int j) {
	style=j;
    }

    public String toString() {
	return (x+"\t"+y);
    }

}
