import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.applet.Applet;
import java.applet.AudioClip;
import java.lang.Math;
import java.io.*;
import java.net.URL;

public class ExampleApplet extends Applet implements AdjustmentListener,
						ActionListener {

    SectorCanvas plot;
    Button clear;
    TextField n;
    SerialData zeros, szego;
    Scrollbar zselect;
    PlotCanvas plot2;
    AudioClip aclip;
    int tail=0;   
    boolean retail=false;

    int last_n;

    public void init() {
	// Load the serialized polynomial zeros
	zeros=readData("zeros.data");
	szego=readData("szego.data");
	aclip=getAudioClip(getCodeBase(),"pop.au");
	
	clear=new Button("Clear history");
	clear.addActionListener(this);
	clear.setActionCommand("Clear");
	n=new TextField("1",9);
	n.setBackground(Color.white);
	plot2 = new PlotCanvas();
	plot2.setScale(0,100.5,-1.2,3.2);
	plot2.autoScale=false;
	plot2.ticks=true;
	plot2.ntick=1;
	plot2.axesColor=new Color(0,0,0);
	plot2.tickColor=new Color(210,210,210);
	plot2.gridlines=true;
	plot2.setSize(getSize().width,60);
	plot = new SectorCanvas(plot2,szego);
	plot.setSquareAspectRatio(true);
	plot.setScale(-1.05,1.05,-1.05,1.05);

	plot2.addMouseListener(new eMouse());

	// set up the interface
	Panel panel=new Panel(new BorderLayout());
	Panel panel2=new Panel(new BorderLayout());
	zselect = new Scrollbar(Scrollbar.HORIZONTAL,1,1,1,zeros.data.size()+1);
	Panel controlPanel = new Panel(new BorderLayout());
	controlPanel.add("West",n);
	controlPanel.add("Center",zselect);
	controlPanel.add("East",clear);
	zselect.addAdjustmentListener(this);
	n.addKeyListener(new ZKey());
	
	setLayout(new BorderLayout(1, 1));
	panel.add("Center",plot);
	panel.add("South",controlPanel);
	add("Center",panel);
	panel2.add("Center",plot2);
	add("South",panel2);

	MPoint p=new MPoint(-1.0,0.0);
	p.setStyle(MPoint.STYLE_CROSS);
	p.setSize(2);
	p.setColor(new Color(1,1,255));
	plot.plot(p);
	Thread refresh=new refreshPlot ();
	refresh.start ();

	last_n=0;

    }


    public void replot() {
	plot.fade();
	try {
	    Integer I=new Integer(n.getText());
	    last_n=I.intValue();;
	    Zeros z=(Zeros)zeros.data.elementAt(last_n-1);
	    Vector v=new Vector();
	    
	    for(int j=0;j<z.length;j++){
//System.out.println(j+"\t"+z.data[j][0]+"\t"+z.data[j][1]);
		MPoint p=new MPoint(z.data[j][0],z.data[j][1]);
		p.setStyle(MPoint.STYLE_CROSS);
		//		p.setStyle(MPoint.STYLE_DISC);
		p.setSize(2);
		p.setColor(new Color(1,1,255));
		v.addElement(p);
	    }
	    plot.plot(v);
	    plot.setDegree (last_n);
	}
	catch (Exception ex) { 
	    System.err.println(ex.toString());
	}
    }




    public SerialData readData(String objectName) {
/* Read serialized object data from an archive data file */
	SerialData d=null;
        ObjectInputStream ois = null;
        try {
	    URL objectURL = getClass().getResource(objectName);
            ois = new ObjectInputStream(objectURL.openConnection().getInputStream());
            d = (SerialData)ois.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ois != null) {
                try {ois.close();} 
                 catch (IOException ioe) {}
            }
        }
	return d;
    }



    public void actionPerformed(ActionEvent e){
	if(e.getActionCommand()=="Clear")  {
		plot2.clear();
		plot.dh=new Vector();
	        plot.dh.addElement(new MPoint(0,-1000.0," ")); // 1st point is a label
		for (int j=1;j<100;j++)
			plot.dh.addElement(new MPoint(0,-1000.0));	
		plot.max_discrepancy=0.3829;
		plot.max_discrepancy_theta=Math.PI/2;
		plot.max_discrepancy_degree=1;
		plot.min_discrepancy=0.3829;
		plot.min_discrepancy_theta=Math.PI/2;
		plot.min_discrepancy_degree=1;
	}
    }


    public void adjustmentValueChanged(AdjustmentEvent e) { 
        n.setText(zselect.getValue()+""); 
	try {
	    Integer I=new Integer(n.getText());
	    if(Math.abs(I.intValue() - last_n)>1) {
		plot.clear();
		tail=0;
		retail=false;
	    }
	    else  {tail=0; retail=true;}
	    replot();
	}
	catch(Exception ex){ };
    } 


    class refreshPlot extends Thread {
      public void run () {
	while (true) {
	  tail++;
	  try { sleep(100); }
	  catch (Exception ex) {}
	  if (tail>3 && retail){
		plot.clear();
		replot();
		retail=false;
		tail=0;
	  }
        }
      }
    }

    class ZKey implements KeyListener {
        public void keyTyped(KeyEvent e) { }
        public void keyPressed(KeyEvent e) { }
        public void keyReleased(KeyEvent e) {
            if(e.getKeyCode()==KeyEvent.VK_ENTER) {
		int j=last_n;
		try{
		    Integer I=new Integer(n.getText());
		    j=I.intValue();
		    if(j<1) {
			j=1;
			n.setText(""+j);
		    }
		    if(j>200) {
			j=200;
			n.setText(""+j);
		    }
		    zselect.setValue(j);
		    plot.clear();
		    tail=0;
		    retail=false;
		    replot();
		} catch(Exception ex) {};
            }
        }

    }

    class eMouse extends MouseAdapter{
        public void mousePressed(MouseEvent e) {
		plot.max_discrepancy_visible=!plot.max_discrepancy_visible;	
		aclip.play();
        }

        public void mouseReleased(MouseEvent e) {
        }
    }



}
